package edu.cmu.cs.cs214.concurrencyframework;

import java.util.Arrays;
import java.util.Random;

import org.junit.Test;
import org.junit.Assert;

public class Main {
	public static final int SIZE = (int) Math.round(Math.pow(2, 27));
	
	static void initArray(long[] a) {
		Random rand = new Random();
		for (int i = 0; i < a.length; ++i) {
			a[i] = rand.nextInt(1000000);
		}
	}
	
	public static void main(String[] args) {
		long[] x = new long[SIZE];
	    long[] y, z;
		long startTime, endTime;
		
		initArray(x);
		y = Arrays.copyOf(x, x.length);
		z = Arrays.copyOf(x, x.length);
		
		startTime = System.currentTimeMillis();
		new PrefixSumsNonconcurrentParallelWorkImpl().computePrefixSums(y);
		endTime = System.currentTimeMillis();
		System.out.println("Parallel work: " + (endTime-startTime) + " core milliseconds.");
		
		
		startTime = System.currentTimeMillis();
		new PrefixSumsParallelImpl().computePrefixSums(z);
		endTime = System.currentTimeMillis();
		System.out.println("Parallel depth: " + (endTime-startTime) + " milliseconds.");
		
		
		startTime = System.currentTimeMillis();
		new PrefixSumsSequentialImpl().computePrefixSums(x);
		endTime = System.currentTimeMillis();
		System.out.println("Sequential depth: " + (endTime-startTime) + " milliseconds.");
		
	}
	
	
	@Test
	public void sanityCheck() {
		long[] x = new long[(int) Math.round(Math.pow(2, 20))];
	    long[] y, z;
		
		initArray(x);
		y = Arrays.copyOf(x, x.length);
		z = Arrays.copyOf(x, x.length);
		
		new PrefixSumsSequentialImpl().computePrefixSums(x);
		new PrefixSumsNonconcurrentParallelWorkImpl().computePrefixSums(y);
		new PrefixSumsParallelImpl().computePrefixSums(z);

		Assert.assertArrayEquals("Non-sequential result should match sequential result", x, y);
		Assert.assertArrayEquals("Parallel result should match sequential result", x, z);
	}

}
